/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AgentCompressionMode {
    DEFAULT(0),
    ENABLED(1),
    DISABLED(2);

    private static Logger logger;
    private static Map<Integer, AgentCompressionMode> lookupTable;
    private int value;

    private AgentCompressionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AgentCompressionMode getByValue(int value) {
        AgentCompressionMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return DEFAULT;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AgentCompressionMode.class);
        lookupTable = new HashMap<Integer, AgentCompressionMode>();
        for (AgentCompressionMode element : AgentCompressionMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

