/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IcmpStatCollectionMode {
    DEFAULT(0),
    ON(1),
    OFF(2);

    private static Logger logger;
    private static Map<Integer, IcmpStatCollectionMode> lookupTable;
    private int value;

    private IcmpStatCollectionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static IcmpStatCollectionMode getByValue(int value) {
        IcmpStatCollectionMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return DEFAULT;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(IcmpStatCollectionMode.class);
        lookupTable = new HashMap<Integer, IcmpStatCollectionMode>();
        for (IcmpStatCollectionMode element : IcmpStatCollectionMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

