/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.Threshold;

public class DataSeries {
    private long nodeId;
    private long dciId;
    private String dciDescription;
    private String dciName;
    private DataType dataType;
    private ArrayList<DciDataRow> values = new ArrayList();
    private Severity activeThresholdSeverity;
    private MeasurementUnit measurementUnits;
    private int multiplierPower;
    private int useMultiplier = 0;
    private Threshold[] thresholds = null;
    private int pollingInterval;
    private boolean storeChangesOnly;

    public DataSeries() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.dataType = DataType.FLOAT;
        this.activeThresholdSeverity = Severity.NORMAL;
    }

    public DataSeries(long nodeId, long dciId) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.dataType = DataType.INT32;
        this.activeThresholdSeverity = Severity.NORMAL;
    }

    public DataSeries(double value) {
        this.dataType = DataType.FLOAT;
        this.values.add(new DciDataRow(new Date(), value));
        this.activeThresholdSeverity = Severity.NORMAL;
    }

    public DataSeries(DataSeries src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.dciDescription = src.dciDescription;
        this.dciName = src.dciName;
        this.dataType = src.dataType;
        this.values.addAll(src.values);
        this.activeThresholdSeverity = src.activeThresholdSeverity;
        this.measurementUnits = src.measurementUnits;
        this.multiplierPower = src.multiplierPower;
        this.useMultiplier = src.useMultiplier;
        this.thresholds = src.thresholds;
        this.pollingInterval = src.pollingInterval;
        this.storeChangesOnly = src.storeChangesOnly;
    }

    public void updateFromMessage(NXCPMessage msg) {
        this.dciName = msg.getFieldAsString(600L);
        this.dciDescription = msg.getFieldAsString(27L);
        this.activeThresholdSeverity = Severity.getByValue(msg.getFieldAsInt32(244L));
        this.multiplierPower = msg.getFieldAsInt32(323L);
        this.useMultiplier = msg.getFieldAsInt32(869L);
        this.pollingInterval = msg.getFieldAsInt32(44L);
        this.storeChangesOnly = msg.getFieldAsBoolean(103L);
        String units = msg.getFieldAsString(324L);
        this.measurementUnits = units != null && !units.isBlank() ? new MeasurementUnit(units) : null;
        int count2 = msg.getFieldAsInt32(54L);
        this.thresholds = new Threshold[count2];
        long fieldId = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.thresholds[i] = new Threshold(msg, fieldId);
            ++i;
            fieldId += 20L;
        }
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public DciDataRow[] getValues() {
        return this.values.toArray(new DciDataRow[this.values.size()]);
    }

    public DciDataRow getLastValue() {
        return this.values.size() > 0 ? this.values.get(this.values.size() - 1) : null;
    }

    public double getCurrentValue() {
        return this.values.size() > 0 ? this.values.get(this.values.size() - 1).getValueAsDouble() : 0.0;
    }

    public double getMinValue() {
        if (this.values.size() == 0) {
            return 0.0;
        }
        double minValue = this.values.get(0).getValueAsDouble();
        for (int i = 1; i < this.values.size(); ++i) {
            double curr = this.values.get(i).getValueAsDouble();
            if (!(curr < minValue)) continue;
            minValue = curr;
        }
        return minValue;
    }

    public double getMaxValue() {
        if (this.values.size() == 0) {
            return 0.0;
        }
        double maxValue = this.values.get(0).getValueAsDouble();
        for (int i = 1; i < this.values.size(); ++i) {
            double curr = this.values.get(i).getValueAsDouble();
            if (!(curr > maxValue)) continue;
            maxValue = curr;
        }
        return maxValue;
    }

    public double getAverageValue() {
        if (this.values.size() == 0) {
            return 0.0;
        }
        double sum = this.values.get(0).getValueAsDouble();
        for (int i = 1; i < this.values.size(); ++i) {
            sum += this.values.get(i).getValueAsDouble();
        }
        return sum / (double)this.values.size();
    }

    public String getCurrentValueAsString() {
        return this.values.size() > 0 ? this.values.get(this.values.size() - 1).getValueAsString() : "";
    }

    public void addDataRow(DciDataRow row) {
        this.values.add(row);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void invert() {
        for (DciDataRow r : this.values) {
            r.invert();
        }
    }

    public Severity getActiveThresholdSeverity() {
        return this.activeThresholdSeverity;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnits;
    }

    public int getMultiplierPower() {
        return this.multiplierPower;
    }

    public int getUseMultiplier() {
        return this.useMultiplier;
    }

    public DataFormatter getDataFormatter() {
        return new DataFormatter(this);
    }

    public Threshold[] getThresholds() {
        return this.thresholds;
    }

    public String getDciDescription() {
        return this.dciDescription;
    }

    public String getDciName() {
        return this.dciName;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isStoreChangesOnly() {
        return this.storeChangesOnly;
    }

    public String toString() {
        return "DciData [nodeId=" + this.nodeId + ", dciId=" + this.dciId + ", dciName=" + this.dciName + ", dciDescription=" + this.dciDescription + ", dataType=" + String.valueOf((Object)this.dataType) + ", valuesSize=" + this.values.size() + ", activeThresholdSeverity=" + String.valueOf((Object)this.activeThresholdSeverity) + ", multiplierPower=" + this.multiplierPower + ", useMultiplier=" + this.useMultiplier + ", measurementUnits=" + String.valueOf(this.measurementUnits) + ", thresholds= " + String.valueOf(this.thresholds) + "]";
    }
}

