/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.IncidentState;

public class IncidentSummary {
    private long id;
    private Date creationTime;
    private Date lastChangeTime;
    private IncidentState state;
    private int assignedUserId;
    private String title;
    private long sourceObjectId;
    private int alarmCount;

    public IncidentSummary(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.creationTime = msg.getFieldAsDate(baseId + 1L);
        this.lastChangeTime = msg.getFieldAsDate(baseId + 2L);
        this.state = IncidentState.getByValue(msg.getFieldAsInt32(baseId + 3L));
        this.assignedUserId = msg.getFieldAsInt32(baseId + 4L);
        this.title = msg.getFieldAsString(baseId + 5L);
        this.sourceObjectId = msg.getFieldAsInt64(baseId + 6L);
        this.alarmCount = msg.getFieldAsInt32(baseId + 7L);
    }

    public long getId() {
        return this.id;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public IncidentState getState() {
        return this.state;
    }

    public int getAssignedUserId() {
        return this.assignedUserId;
    }

    public String getTitle() {
        return this.title;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public int getAlarmCount() {
        return this.alarmCount;
    }

    public boolean isClosed() {
        return this.state == IncidentState.CLOSED;
    }

    public boolean isResolved() {
        return this.state == IncidentState.RESOLVED || this.state == IncidentState.CLOSED;
    }

    public String toString() {
        return "IncidentSummary [id=" + this.id + ", creationTime=" + String.valueOf(this.creationTime) + ", lastChangeTime=" + String.valueOf(this.lastChangeTime) + ", state=" + String.valueOf((Object)this.state) + ", assignedUserId=" + this.assignedUserId + ", title=" + this.title + ", sourceObjectId=" + this.sourceObjectId + ", alarmCount=" + this.alarmCount + "]";
    }
}

