/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class HopInfo {
    public static final int ROUTE = 0;
    public static final int VPN = 1;
    public static final int PROXY = 2;
    public static final int DUMMY = 3;
    private int index;
    private long nodeId;
    private InetAddress nextHop;
    private int ifIndex;
    private int type;
    private String name;

    public HopInfo(int index) {
        this.index = index;
        this.nodeId = -1L;
        this.nextHop = null;
        this.ifIndex = 0;
        this.type = 3;
        this.name = "";
    }

    protected HopInfo(NXCPMessage msg, long baseId, int index) {
        this.index = index;
        this.nodeId = msg.getFieldAsInt64(baseId);
        this.nextHop = msg.getFieldAsInetAddress(baseId + 1L);
        this.ifIndex = msg.getFieldAsInt32(baseId + 2L);
        this.type = msg.getFieldAsInt32(baseId + 3L);
        this.name = msg.getFieldAsString(baseId + 4L);
    }

    public int getIndex() {
        return this.index;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }
}

