/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.jira.workflow;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.radensolutions.jira.NetxmsConnector;
import com.radensolutions.jira.SettingsManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAlarmFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = LoggerFactory.getLogger(UpdateAlarmFunction.class);
    public static final String ACKNOWLEDGED = "acknowledged";
    public static final String RESOLVED = "resolved";
    public static final String TERMINATED = "terminated";
    private final NetxmsConnector connector;
    private SettingsManager settingsManager;

    public UpdateAlarmFunction(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
        this.connector = settingsManager.isEnabled() ? new NetxmsConnector(settingsManager) : null;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        if (this.connector == null) {
            return;
        }
        MutableIssue issue = this.getIssue(transientVars);
        if (!issue.getProjectObject().getKey().equalsIgnoreCase(this.settingsManager.getProjectKey())) {
            return;
        }
        if (args.containsKey("selectedAction")) {
            String operation = (String)args.get("selectedAction");
            String issueKey = issue.getKey();
            log.debug(String.format("Update alarm, operation: %s, key: %s", operation, issueKey));
            boolean ret = true;
            if (operation.equals(ACKNOWLEDGED)) {
                ret = this.connector.acknowledgeAlarm(issueKey);
            } else if (operation.equals(RESOLVED)) {
                ret = this.connector.resolveAlarm(issueKey);
            } else if (operation.equals(TERMINATED)) {
                ret = this.connector.terminateAlarm(issueKey);
            }
            if (!ret) {
                throw new WorkflowException("Unable to change NetXMS alarm state");
            }
        }
    }
}

