/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HardwareComponentCategory {
    OTHER(0),
    BASEBOARD(1),
    PROCESSOR(2),
    MEMORY_DEVICE(3),
    STORAGE_DEVICE(4),
    BATTERY(5),
    NETWORK_ADAPTER(6);

    private static Logger logger;
    private static Map<Integer, HardwareComponentCategory> lookupTable;
    private int value;

    private HardwareComponentCategory(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HardwareComponentCategory getByValue(int value) {
        HardwareComponentCategory element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return OTHER;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(HardwareComponentCategory.class);
        lookupTable = new HashMap<Integer, HardwareComponentCategory>();
        for (HardwareComponentCategory element : HardwareComponentCategory.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

