/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CertificateMappingMethod {
    SUBJECT(0),
    PUBLIC_KEY(1),
    COMMON_NAME(2),
    TEMPLATE_ID(3);

    private static Logger logger;
    private static Map<Integer, CertificateMappingMethod> lookupTable;
    private int value;

    private CertificateMappingMethod(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CertificateMappingMethod getByValue(int value) {
        CertificateMappingMethod element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return SUBJECT;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(CertificateMappingMethod.class);
        lookupTable = new HashMap<Integer, CertificateMappingMethod>();
        for (CertificateMappingMethod element : CertificateMappingMethod.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

