/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config", strict=false)
public class LinkConfig {
    @ElementArray(required=false)
    private SingleDciConfig[] dciList;
    @ElementList(required=false)
    private List<Long> objectStatusList = new ArrayList<Long>();
    @Element(required=false)
    private int routing;
    @Element(required=false)
    private long[] bendPoints;
    @Element(required=false)
    private boolean useActiveThresholds;
    @Element(required=false)
    private boolean isLocked;

    public LinkConfig() {
        this.routing = 0;
        this.bendPoints = null;
        this.dciList = null;
        this.useActiveThresholds = false;
        this.isLocked = false;
    }

    public LinkConfig(SingleDciConfig[] dciList, List<Long> objectStatusList, int routing, long[] bendPoints, boolean useActiveThresholds, boolean isLocked) {
        this.dciList = dciList;
        this.objectStatusList = objectStatusList;
        this.routing = routing;
        this.bendPoints = bendPoints;
        this.useActiveThresholds = useActiveThresholds;
        this.isLocked = isLocked;
    }

    public static LinkConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (LinkConfig)((Object)serializer.read(LinkConfig.class, xml));
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public List<Long> getObjectStatusList() {
        return this.objectStatusList != null ? this.objectStatusList : new ArrayList(0);
    }

    public void setObjectStatusList(List<Long> objectStatusList) {
        this.objectStatusList = objectStatusList;
    }

    public SingleDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(SingleDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getRouting() {
        return this.routing;
    }

    public void setRouting(int routing) {
        this.routing = routing;
    }

    public long[] getBendPoints() {
        return this.bendPoints;
    }

    public void setBendPoints(long[] bendPoints) {
        this.bendPoints = bendPoints;
    }

    public void setUseActiveThresholds(boolean useActiveThresholds) {
        this.useActiveThresholds = useActiveThresholds;
    }

    public boolean isUseActiveThresholds() {
        return this.useActiveThresholds;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public String toString() {
        return "LinkConfig [dciList=" + Arrays.toString(this.dciList) + ", objectStatusList=" + this.objectStatusList.toString() + ", routing=" + this.routing + ", bendPoints=" + Arrays.toString(this.bendPoints) + ", isLocked=" + this.isLocked + "]";
    }
}

