/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.CoordinateListener;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.zest.core.widgets.FisheyeListener;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.IDecorationFigure;
import org.eclipse.gef4.zest.core.widgets.IDecorationLayer;
import org.eclipse.gef4.zest.core.widgets.InternalLayoutContext;
import org.eclipse.gef4.zest.core.widgets.LayoutFilter;
import org.eclipse.gef4.zest.core.widgets.SubgraphFactory;
import org.eclipse.gef4.zest.core.widgets.decoration.DefaultConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.decoration.DirectedConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.decoration.IConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.gestures.RotateGestureListener;
import org.eclipse.gef4.zest.core.widgets.gestures.ZoomGestureListener;
import org.eclipse.gef4.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.gef4.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.gef4.zest.core.widgets.zooming.ZoomManager;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.gef4.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ControlPaintHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class Graph
extends FigureCanvas
implements IContainer {
    public static final int ANIMATION_TIME = 500;
    public static final int FISHEYE_ANIMATION_TIME = 100;
    public Color LIGHT_BLUE = new Color(null, 216, 228, 248);
    public Color LIGHT_BLUE_CYAN = new Color(null, 213, 243, 255);
    public Color GREY_BLUE = new Color(null, 139, 150, 171);
    public Color DARK_BLUE = new Color(null, 1, 70, 122);
    public Color LIGHT_YELLOW = new Color(null, 255, 255, 206);
    public Color HIGHLIGHT_COLOR = ColorConstants.yellow;
    public Color HIGHLIGHT_ADJACENT_COLOR = ColorConstants.orange;
    public Color DEFAULT_NODE_COLOR = this.LIGHT_BLUE;
    private List nodes;
    protected List connections;
    HashSet subgraphFigures;
    private List selectedItems = null;
    private ArrayList fisheyeListeners = new ArrayList();
    private List selectionListeners = null;
    private HashMap figure2ItemMap = null;
    private int connectionStyle;
    private int nodeStyle;
    private ScalableFreeformLayeredPane fishEyeLayer = null;
    private InternalLayoutContext layoutContext = null;
    private volatile boolean shouldSheduleLayout;
    private volatile Runnable scheduledLayoutRunnable = null;
    private volatile boolean scheduledLayoutClean = false;
    private Dimension preferredSize = null;
    private boolean draggingEnabled = true;
    int style = 0;
    private ScalableFreeformLayeredPane rootlayer;
    private ZestRootLayer zestRootLayer;
    private ConnectionRouter defaultConnectionRouter;
    private IConnectionDecorator defaultConnectionDecorator = new DefaultConnectionDecorator();
    private IConnectionDecorator defaultDirectedConnectionDecorator = new DirectedConnectionDecorator();
    private ZoomManager zoomManager = null;
    boolean animate = false;
    private boolean nodeDragging = false;

    public Graph(Composite parent, int style) {
        super(parent, (style | 0x20000000) & 0xFFFFFFBF);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.setViewport((Viewport)new FreeformViewport());
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null || Graph.this.nodeDragging && this.getMouseTarget() instanceof IDecorationFigure) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    if (this.getMouseTarget() instanceof Figure && !((Figure)this.getMouseTarget()).isOpaque()) {
                        this.getRoot().handleMouseDragged(this.getCurrentEvent());
                    } else {
                        this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                    }
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents((IFigure)this.createLayers());
        DragSupport dragSupport = new DragSupport();
        this.zestRootLayer.addMouseListener(dragSupport);
        this.zestRootLayer.addMouseMotionListener(dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new ArrayList();
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new ArrayList();
        this.subgraphFigures = new HashSet();
        this.selectedItems = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.figure2ItemMap = new HashMap();
        ControlPaintHandler helper = new ControlPaintHandler((Control)this);
        helper.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (Graph.this.shouldSheduleLayout) {
                    Graph.this.applyLayoutInternal(true);
                    Graph.this.shouldSheduleLayout = false;
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (((Graph)Graph.this).preferredSize.width == -1 || ((Graph)Graph.this).preferredSize.height == -1) {
                    Graph.this.getLayoutContext().fireBoundsChangedEvent();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        if ((style & 0x40) == 0) {
            this.addGestureListener(new ZoomGestureListener());
            this.addGestureListener(new RotateGestureListener());
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Graph.this.release();
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    @Override
    public List getNodes() {
        return this.nodes;
    }

    public ScalableFigure getRootLayer() {
        return this.rootlayer;
    }

    public FreeformLayer getZestRootLayer() {
        return this.zestRootLayer;
    }

    public void setConnectionStyle(int connectionStyle) {
        this.connectionStyle = connectionStyle;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public List getConnections() {
        return this.connections;
    }

    public void setSelection(GraphItem[] items) {
        this.clearSelection();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] != null) {
                    this.select(items[i]);
                }
                ++i;
            }
        }
    }

    public void selectAll() {
        this.setSelection(this.nodes.toArray(new GraphItem[0]));
    }

    public List getSelection() {
        return this.selectedItems;
    }

    public String toString() {
        return "GraphModel {" + this.nodes.size() + " nodes, " + this.connections.size() + " connections}";
    }

    public void dispose() {
        this.release();
        super.dispose();
    }

    @Override
    public void applyLayout() {
        this.scheduleLayoutOnReveal(true);
    }

    public void applyLayoutNow() {
        this.getLayoutContext().applyLayout(true);
        this.layoutContext.flushChanges(false);
    }

    public void setDynamicLayout(boolean enabled) {
        if (this.getLayoutContext().isBackgroundLayoutEnabled() != enabled) {
            this.layoutContext.setBackgroundLayoutEnabled(enabled);
            if (enabled) {
                this.scheduleLayoutOnReveal(false);
            }
        }
    }

    public boolean isDynamicLayoutEnabled() {
        return this.getLayoutContext().isBackgroundLayoutEnabled();
    }

    private void release() {
        while (this.nodes.size() > 0) {
            GraphNode node = (GraphNode)((Object)this.nodes.get(0));
            if (node == null) continue;
            node.dispose();
        }
        while (this.connections.size() > 0) {
            GraphConnection connection = (GraphConnection)((Object)this.connections.get(0));
            if (connection == null) continue;
            connection.dispose();
        }
        this.LIGHT_BLUE.dispose();
        this.LIGHT_BLUE_CYAN.dispose();
        this.GREY_BLUE.dispose();
        this.DARK_BLUE.dispose();
        this.LIGHT_YELLOW.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLayoutInternal(boolean clean) {
        if (this.getLayoutContext().getLayoutAlgorithm() == null) {
            return;
        }
        this.scheduledLayoutClean = this.scheduledLayoutClean || clean;
        Graph graph = this;
        synchronized (graph) {
            if (this.scheduledLayoutRunnable == null) {
                this.scheduledLayoutRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (Graph.this.animate) {
                            Animation.markBegin();
                        }
                        Graph.this.getLayoutContext().applyLayout(Graph.this.scheduledLayoutClean);
                        Graph.this.layoutContext.flushChanges(false);
                        if (Graph.this.animate) {
                            Animation.run((int)500);
                        }
                        Graph.this.getLightweightSystem().getUpdateManager().performUpdate();
                        Graph graph = Graph.this;
                        synchronized (graph) {
                            Graph.this.scheduledLayoutRunnable = null;
                            Graph.this.scheduledLayoutClean = false;
                        }
                    }
                };
                this.getDisplay().asyncExec(this.scheduledLayoutRunnable);
            }
        }
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
        this.getLayoutContext().fireBoundsChangedEvent();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize.width < 0 || this.preferredSize.height < 0) {
            org.eclipse.swt.graphics.Point size = this.getSize();
            double scale = this.getZoomManager().getZoom();
            return new Dimension((int)((double)size.x / scale + 0.5), (int)((double)size.y / scale + 0.5));
        }
        return this.preferredSize;
    }

    @Override
    public InternalLayoutContext getLayoutContext() {
        if (this.layoutContext == null) {
            this.layoutContext = new InternalLayoutContext(this);
        }
        return this.layoutContext;
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.getLayoutContext().setLayoutAlgorithm(algorithm);
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.getLayoutContext().getLayoutAlgorithm();
    }

    public void setSubgraphFactory(SubgraphFactory factory) {
        this.getLayoutContext().setSubgraphFactory(factory);
    }

    public SubgraphFactory getSubgraphFactory() {
        return this.getLayoutContext().getSubgraphFactory();
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.getLayoutContext().setExpandCollapseManager(expandCollapseManager);
        this.setDynamicLayout(true);
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.getLayoutContext().getExpandCollapseManager();
    }

    public void addLayoutFilter(LayoutFilter filter) {
        this.getLayoutContext().addFilter(filter);
    }

    public void removeLayoutFilter(LayoutFilter filter) {
        this.getLayoutContext().removeFilter(filter);
    }

    public IFigure getFigureAt(int x, int y) {
        IFigure figureUnderMouse = this.getContents().findFigureAt(x, y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return true;
            }

            public boolean prune(IFigure figure) {
                IFigure parent = figure.getParent();
                if (parent == Graph.this.fishEyeLayer) {
                    return true;
                }
                if (parent instanceof ContainerFigure && figure instanceof PolylineConnection) {
                    return false;
                }
                if (parent == Graph.this.zestRootLayer || parent == Graph.this.zestRootLayer.getParent() || parent == Graph.this.zestRootLayer.getParent().getParent()) {
                    return false;
                }
                GraphItem item = (GraphItem)((Object)Graph.this.figure2ItemMap.get(figure));
                if (item != null && item.getItemType() == 3) {
                    return false;
                }
                return !(figure instanceof FreeformLayer) && !(parent instanceof FreeformLayer) && !(figure instanceof ScrollPane) && !(parent instanceof ScrollPane) && !(parent instanceof ScalableFreeformLayeredPane) && !(figure instanceof ScalableFreeformLayeredPane) && !(figure instanceof FreeformViewport) && !(parent instanceof FreeformViewport);
            }
        });
        return figureUnderMouse;
    }

    public void notifyListeners(int eventType, Event event) {
        super.notifyListeners(eventType, event);
        if (eventType == 13 && event != null) {
            this.notifySelectionListeners(new SelectionEvent(event));
        }
    }

    private void clearSelection() {
        Iterator iterator = new ArrayList(this.selectedItems).iterator();
        while (iterator.hasNext()) {
            this.deselect((GraphItem)((Object)iterator.next()));
        }
    }

    private void fireWidgetSelectedEvent(Item item) {
        Event swtEvent = new Event();
        swtEvent.item = item;
        swtEvent.widget = this;
        this.notifySelectionListeners(new SelectionEvent(swtEvent));
    }

    private void notifySelectionListeners(SelectionEvent event) {
        Iterator iterator = this.selectionListeners.iterator();
        while (iterator.hasNext()) {
            ((SelectionListener)iterator.next()).widgetSelected(event);
        }
    }

    private void deselect(GraphItem item) {
        this.selectedItems.remove((Object)item);
        item.unhighlight();
        this.setNodeSelected(item, false);
    }

    private void select(GraphItem item) {
        this.selectedItems.add(item);
        item.highlight();
        this.setNodeSelected(item, true);
    }

    private void setNodeSelected(GraphItem item, boolean selected) {
        if (item instanceof GraphNode) {
            ((GraphNode)item).setSelected(selected);
        }
    }

    GraphConnection[] getConnectionsArray() {
        GraphConnection[] connsArray = new GraphConnection[this.connections.size()];
        connsArray = this.connections.toArray(connsArray);
        return connsArray;
    }

    public void clear() {
        Iterator i = new ArrayList(this.connections).iterator();
        while (i.hasNext()) {
            this.removeConnection((GraphConnection)((Object)i.next()));
        }
        i = new HashSet(this.subgraphFigures).iterator();
        while (i.hasNext()) {
            this.removeSubgraphFigure((IFigure)i.next());
        }
        i = new ArrayList(this.nodes).iterator();
        while (i.hasNext()) {
            this.removeNode((GraphNode)((Object)i.next()));
        }
    }

    void removeConnection(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        PolylineConnection sourceContainerConnectionFigure = connection.getSourceContainerConnectionFigure();
        PolylineConnection targetContainerConnectionFigure = connection.getTargetContainerConnectionFigure();
        connection.removeFigure();
        this.getConnections().remove((Object)connection);
        this.selectedItems.remove((Object)connection);
        this.figure2ItemMap.remove(figure);
        if (sourceContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(sourceContainerConnectionFigure);
        }
        if (targetContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(targetContainerConnectionFigure);
        }
        this.getLayoutContext().fireConnectionRemovedEvent(connection.getLayout());
    }

    void removeNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
        this.getNodes().remove((Object)node);
        this.selectedItems.remove((Object)node);
        this.figure2ItemMap.remove(figure);
        node.getLayout().dispose();
    }

    void addConnection(GraphConnection connection, boolean addToEdgeLayer) {
        this.getConnections().add(connection);
        if (addToEdgeLayer) {
            this.zestRootLayer.addConnection(connection.getFigure());
        }
        this.getLayoutContext().fireConnectionAddedEvent(connection.getLayout());
    }

    @Override
    public void addNode(GraphNode node) {
        this.getNodes().add(node);
        this.zestRootLayer.addNode(node.getFigure());
        this.getLayoutContext().fireNodeAddedEvent(node.getLayout());
    }

    @Override
    public void addSubgraphFigure(IFigure figure) {
        this.zestRootLayer.addSubgraph(figure);
        this.subgraphFigures.add(figure);
    }

    void removeSubgraphFigure(IFigure figure) {
        this.subgraphFigures.remove(figure);
        figure.getParent().remove(figure);
    }

    void registerItem(GraphItem item) {
        if (item.getItemType() == 1) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else if (item.getItemType() == 2) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
            if (((GraphConnection)item).getSourceContainerConnectionFigure() != null) {
                this.figure2ItemMap.put(((GraphConnection)item).getSourceContainerConnectionFigure(), item);
            }
            if (((GraphConnection)item).getTargetContainerConnectionFigure() != null) {
                this.figure2ItemMap.put(((GraphConnection)item).getTargetContainerConnectionFigure(), item);
            }
        } else if (item.getItemType() == 3) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else {
            throw new RuntimeException("Unknown item type: " + item.getItemType());
        }
    }

    private void scheduleLayoutOnReveal(boolean clean) {
        final boolean[] isVisibleSync = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                isVisibleSync[0] = Graph.this.isVisible();
            }
        });
        if (isVisibleSync[0]) {
            this.applyLayoutInternal(clean);
        } else {
            this.shouldSheduleLayout = true;
        }
    }

    private ScalableFigure createLayers() {
        this.rootlayer = new ScalableFreeformLayeredPane();
        this.rootlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.zestRootLayer = new ZestRootLayer();
        this.zestRootLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.fishEyeLayer = new ScalableFreeformLayeredPane();
        this.fishEyeLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootlayer.add((IFigure)this.zestRootLayer);
        this.rootlayer.add((IFigure)this.fishEyeLayer);
        this.zestRootLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.fishEyeLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.rootlayer.addCoordinateListener(new CoordinateListener(){

            public void coordinateSystemChanged(IFigure source) {
                if (((Graph)Graph.this).preferredSize.width == -1 && ((Graph)Graph.this).preferredSize.height == -1) {
                    Graph.this.getLayoutContext().fireBoundsChangedEvent();
                }
            }
        });
        return this.rootlayer;
    }

    void removeFishEye(IFigure fishEyeFigure, IFigure regularFigure, boolean animate) {
        if (!this.fishEyeLayer.getChildren().contains(fishEyeFigure)) {
            return;
        }
        if (animate) {
            Animation.markBegin();
        }
        Rectangle bounds = regularFigure.getBounds().getCopy();
        regularFigure.translateToAbsolute((Translatable)bounds);
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        this.fishEyeLayer.setConstraint(fishEyeFigure, (Object)bounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeRemoved(this, regularFigure, fishEyeFigure);
        }
        if (animate) {
            Animation.run((int)200);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
        this.fishEyeLayer.removeAll();
    }

    boolean replaceFishFigure(IFigure oldFigure, IFigure newFigure) {
        if (this.fishEyeLayer.getChildren().contains(oldFigure)) {
            Rectangle bounds = oldFigure.getBounds();
            newFigure.setBounds(bounds);
            this.fishEyeLayer.remove(oldFigure);
            this.fishEyeLayer.add(newFigure);
            for (FisheyeListener listener : this.fisheyeListeners) {
                listener.fisheyeReplaced(this, oldFigure, newFigure);
            }
            return true;
        }
        return false;
    }

    void fishEye(IFigure startFigure, IFigure endFigure, Rectangle newBounds, boolean animate) {
        this.fishEyeLayer.removeAll();
        if (animate) {
            Animation.markBegin();
        }
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)newBounds);
        this.fishEyeLayer.translateFromParent((Translatable)newBounds);
        Rectangle bounds = startFigure.getBounds().getCopy();
        startFigure.translateToAbsolute((Translatable)bounds);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        endFigure.setLocation(bounds.getLocation());
        endFigure.setSize(bounds.getSize());
        this.fishEyeLayer.add(endFigure);
        this.fishEyeLayer.setConstraint(endFigure, (Object)newBounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeAdded(this, startFigure, endFigure);
        }
        if (animate) {
            Animation.run((int)100);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    public void addFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.add(listener);
    }

    public void removeFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.remove(listener);
    }

    @Override
    public int getItemType() {
        return 0;
    }

    GraphItem getGraphItem(IFigure figure) {
        return (GraphItem)((Object)this.figure2ItemMap.get(figure));
    }

    public void setExpanded(GraphNode node, boolean expanded) {
        this.layoutContext.setExpanded(node.getLayout(), expanded);
        this.rootlayer.invalidate();
    }

    public boolean canExpand(GraphNode node) {
        return this.layoutContext.canExpand(node.getLayout());
    }

    public boolean canCollapse(GraphNode node) {
        return this.layoutContext.canCollapse(node.getLayout());
    }

    @Override
    public Graph getGraph() {
        return this;
    }

    @Override
    public Widget getItem() {
        return this;
    }

    @Override
    public DisplayIndependentRectangle getLayoutBounds() {
        Dimension preferredSize = this.getPreferredSize();
        return new DisplayIndependentRectangle(0.0, 0.0, (double)preferredSize.width, (double)preferredSize.height);
    }

    void setDefaultConnectionRouter(ConnectionRouter defaultConnectionRouter) {
        this.defaultConnectionRouter = defaultConnectionRouter;
    }

    ConnectionRouter getDefaultConnectionRouter() {
        return this.defaultConnectionRouter;
    }

    public IConnectionDecorator getDefaultConnectionDecorator() {
        return this.defaultConnectionDecorator;
    }

    public void setDefaultConnectionDecorator(IConnectionDecorator connectionDecorator) {
        this.defaultConnectionDecorator = connectionDecorator == null ? new DefaultConnectionDecorator() : connectionDecorator;
    }

    public IConnectionDecorator getDefaultDirectedConnectionDecorator() {
        return this.defaultDirectedConnectionDecorator;
    }

    public void setDefaultDirectedConnectionDecorator(IConnectionDecorator connectionDecorator) {
        this.defaultDirectedConnectionDecorator = connectionDecorator;
    }

    void applyConnectionRouter() {
        for (GraphConnection conn : this.getConnections()) {
            conn.getConnectionFigure().setConnectionRouter(this.defaultConnectionRouter);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    public void setRouter(ConnectionRouter connectionRouter) {
        this.setDefaultConnectionRouter(connectionRouter);
        this.applyConnectionRouter();
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager(this.getRootLayer(), this.getViewport());
        }
        return this.zoomManager;
    }

    public boolean isAnimationEnabled() {
        return this.animate;
    }

    public void setAnimationEnabled(boolean animate) {
        this.animate = animate;
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public void setDraggingEnabled(boolean draggingEnabled) {
        this.draggingEnabled = draggingEnabled;
    }

    private class DragSupport
    implements MouseMotionListener,
    MouseListener {
        Point dragStartLocation = null;
        IFigure draggedSubgraphFigure = null;
        ArrayList relativeLocations = new ArrayList();
        GraphItem fisheyedItem = null;
        boolean isDragging = false;

        private DragSupport() {
        }

        public void mouseDragged(MouseEvent me) {
            IFigure figureUnderMouse;
            if (!this.isDragging) {
                return;
            }
            if (Graph.this.selectedItems.isEmpty() && Graph.this.subgraphFigures.contains(figureUnderMouse = Graph.this.getFigureAt(this.dragStartLocation.x, this.dragStartLocation.y))) {
                this.draggedSubgraphFigure = figureUnderMouse;
            }
            Point mousePoint = new Point(me.x, me.y);
            if (me.getSource() instanceof ZestRootLayer || me.getSource() instanceof IDecorationFigure) {
                Graph.this.getRootLayer().translateToParent((Translatable)mousePoint);
            }
            if (!Graph.this.selectedItems.isEmpty() || this.draggedSubgraphFigure != null) {
                if (this.relativeLocations.isEmpty()) {
                    for (GraphItem item : Graph.this.selectedItems) {
                        if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                        this.relativeLocations.add(this.getRelativeLocation(item.getFigure()));
                    }
                    if (this.draggedSubgraphFigure != null) {
                        this.relativeLocations.add(this.getRelativeLocation(this.draggedSubgraphFigure));
                    }
                }
                Iterator locationsIterator = this.relativeLocations.iterator();
                for (GraphItem item : Graph.this.selectedItems) {
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    Point pointCopy = mousePoint.getCopy();
                    Point relativeLocation = (Point)locationsIterator.next();
                    if (!(me.getSource() instanceof ZestRootLayer) && !(me.getSource() instanceof IDecorationFigure)) {
                        Graph.this.getRootLayer().translateToRelative((Translatable)pointCopy);
                    }
                    pointCopy.performScale(1.0 / Graph.this.getRootLayer().getScale());
                    pointCopy.translate(relativeLocation.x, relativeLocation.y);
                    ((GraphNode)item).setLocation(pointCopy.x, pointCopy.y);
                }
                if (this.draggedSubgraphFigure != null) {
                    Point pointCopy = mousePoint.getCopy();
                    this.draggedSubgraphFigure.getParent().translateFromParent((Translatable)pointCopy);
                    Point relativeLocation = (Point)locationsIterator.next();
                    pointCopy.x += relativeLocation.x;
                    pointCopy.y += relativeLocation.y;
                    this.draggedSubgraphFigure.setLocation(pointCopy);
                }
            }
        }

        private Point getRelativeLocation(IFigure figure) {
            Point location = figure.getBounds().getTopLeft();
            Graph.this.getRootLayer().translateToParent((Translatable)location);
            location.x -= this.dragStartLocation.x;
            location.y -= this.dragStartLocation.y;
            return location;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            IFigure figureUnderMouse;
            Point mousePoint = new Point(me.x, me.y);
            if (me.getSource() instanceof ZestRootLayer || me.getSource() instanceof IDecorationFigure) {
                Graph.this.getRootLayer().translateToParent((Translatable)mousePoint);
            }
            if ((figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y)) != null) {
                GraphItem itemUnderMouse = (GraphItem)((Object)Graph.this.figure2ItemMap.get(figureUnderMouse));
                if (itemUnderMouse == this.fisheyedItem) {
                    return;
                }
                if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, Graph.this.animate);
                    this.fisheyedItem = null;
                }
                if (itemUnderMouse != null && itemUnderMouse.getItemType() == 1) {
                    this.fisheyedItem = itemUnderMouse;
                    IFigure fisheyedFigure = ((GraphNode)itemUnderMouse).fishEye(true, Graph.this.animate);
                    if (fisheyedFigure == null) {
                        this.fisheyedItem = null;
                    }
                }
            } else if (this.fisheyedItem != null) {
                ((GraphNode)this.fisheyedItem).fishEye(false, Graph.this.animate);
                this.fisheyedItem = null;
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            Point mousePoint = new Point(me.x, me.y);
            if (me.getSource() instanceof ZestRootLayer) {
                Graph.this.getRootLayer().translateToParent((Translatable)mousePoint);
            }
            if (Graph.this.draggingEnabled) {
                this.isDragging = true;
                Graph.this.nodeDragging = true;
                this.dragStartLocation = mousePoint.getCopy();
            }
            if ((me.getState() & SWT.MOD3) != 0) {
                if ((me.getState() & SWT.MOD2) == 0) {
                    double scale = Graph.this.getRootLayer().getScale();
                    Graph.this.getRootLayer().setScale(scale *= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(1.05);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                    Graph.this.getViewport().setViewLocation(newViewLocation);
                    Graph.this.clearSelection();
                    return;
                }
                double scale = Graph.this.getRootLayer().getScale();
                Graph.this.getRootLayer().setScale(scale /= 1.05);
                Point newMousePoint = mousePoint.getCopy().scale(0.9523809523809523);
                Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                Graph.this.getViewport().setViewLocation(newViewLocation);
                Graph.this.clearSelection();
                return;
            }
            boolean hasSelection = Graph.this.selectedItems.size() > 0;
            IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
            Graph.this.getRootLayer().translateFromParent((Translatable)mousePoint);
            if (figureUnderMouse != null) {
                figureUnderMouse.getParent().translateFromParent((Translatable)mousePoint);
            }
            if (figureUnderMouse == null || figureUnderMouse == Graph.this || figureUnderMouse instanceof IDecorationLayer) {
                if ((me.getState() & SWT.MOD1) == 0) {
                    Graph.this.clearSelection();
                    if (hasSelection) {
                        Graph.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            GraphItem itemUnderMouse = (GraphItem)((Object)Graph.this.figure2ItemMap.get(figureUnderMouse));
            if (itemUnderMouse == null) {
                if ((me.getState() & SWT.MOD1) != 0) {
                    Graph.this.clearSelection();
                    if (hasSelection) {
                        Graph.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            if (Graph.this.selectedItems.contains((Object)itemUnderMouse)) {
                if ((me.getState() & SWT.MOD1) != 0) {
                    Graph.this.selectedItems.remove((Object)itemUnderMouse);
                    itemUnderMouse.unhighlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                }
                return;
            }
            if ((me.getState() & SWT.MOD1) == 0) {
                Graph.this.clearSelection();
            }
            if (itemUnderMouse.getItemType() == 1) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphNode)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 2) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphConnection)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 3) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphContainer)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.isDragging = false;
            Graph.this.nodeDragging = false;
            this.relativeLocations.clear();
            this.draggedSubgraphFigure = null;
        }
    }
}

