/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ControlPaintHandler
implements ControlListener {
    private final Control ctrl;
    private List paintListeners;

    public ControlPaintHandler(Control ctrl) {
        this.ctrl = ctrl;
        ctrl.addControlListener((ControlListener)this);
    }

    private void notifyPaintListeners() {
        if (this.paintListeners != null) {
            Event e = new Event();
            e.widget = this.ctrl;
            e.gc = new GC((Drawable)this.ctrl);
            e.height = this.ctrl.getSize().y;
            e.width = this.ctrl.getSize().x;
            e.x = this.ctrl.getLocation().x;
            e.y = this.ctrl.getLocation().y;
            e.data = this.ctrl.getData();
            int i = 0;
            while (i < this.paintListeners.size()) {
                ((PaintListener)this.paintListeners.get(i)).paintControl(new PaintEvent(e));
                ++i;
            }
        }
    }

    public void addPaintListener(PaintListener listener) {
        this.ctrl.getData();
        if (listener == null) {
            this.ctrl.error(4);
        }
        if (this.paintListeners == null) {
            this.paintListeners = new ArrayList();
        }
        if (!this.paintListeners.contains(listener)) {
            this.paintListeners.add(listener);
        }
    }

    public void removePaintListener(PaintListener listener) {
        this.ctrl.getData();
        if (listener == null) {
            this.ctrl.error(4);
        }
        if (this.paintListeners != null) {
            this.paintListeners.remove(listener);
        }
    }

    public void controlMoved(ControlEvent e) {
        this.notifyPaintListeners();
    }

    public void controlResized(ControlEvent e) {
        this.notifyPaintListeners();
    }
}

