/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;

public class Ellipse
extends Shape {
    @Override
    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        Rectangle r = this.getBounds();
        long ux = x - r.x - r.width / 2;
        long uy = y - r.y - r.height / 2;
        return (ux * ux << 10) / (long)(r.width * r.width) + (uy * uy << 10) / (long)(r.height * r.height) <= 256L;
    }

    @Override
    protected void fillShape(Graphics graphics) {
        graphics.fillOval(this.getOptimizedBounds());
    }

    @Override
    protected void outlineShape(Graphics graphics) {
        graphics.drawOval(this.getOptimizedBounds());
    }

    private Rectangle getOptimizedBounds() {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.getSINGLETON().setBounds(this.getBounds());
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        return r;
    }
}

