/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.rap.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ScaledGraphics
extends Graphics {
    private static int[][] intArrayCache = new int[8][];
    private final Rectangle tempRECT = new Rectangle();
    private boolean allowText = true;
    private Map fontCache = new HashMap();
    private Map fontDataCache = new HashMap();
    private FontKey fontKey = new FontKey();
    private double fractionalX;
    private double fractionalY;
    private Graphics graphics;
    private FontHeightCache localCache = new FontHeightCache();
    private Font localFont;
    private float localLineWidth;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    private FontHeightCache targetCache = new FontHeightCache();
    double zoom = 1.0;

    static {
        int i = 0;
        while (i < intArrayCache.length) {
            ScaledGraphics.intArrayCache[i] = new int[i + 1];
            ++i;
        }
    }

    public ScaledGraphics(Graphics g) {
        this.graphics = g;
        this.localFont = g.getFont();
        this.localLineWidth = g.getLineWidthFloat();
    }

    @Override
    public void clipRect(Rectangle r) {
        this.graphics.clipRect(this.zoomClipRect(r));
    }

    Font createFont(FontData data) {
        return new Font((Device)Display.getCurrent(), data);
    }

    private Path createScaledPath(Path path) {
        PathData p = path.getPathData();
        int i = 0;
        while (i < p.points.length) {
            p.points[i] = (float)((double)p.points[i] * this.zoom + this.fractionalX);
            p.points[i + 1] = (float)((double)p.points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        Path scaledPath = new Path(path.getDevice());
        int index = 0;
        int i2 = 0;
        while (i2 < p.types.length) {
            byte type = p.types[i2];
            switch (type) {
                case 1: {
                    scaledPath.moveTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 2: {
                    scaledPath.lineTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 4: {
                    scaledPath.cubicTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3], p.points[index + 4], p.points[index + 5]);
                    index += 6;
                    break;
                }
                case 3: {
                    scaledPath.quadTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3]);
                    index += 4;
                    break;
                }
                case 5: {
                    scaledPath.close();
                }
            }
            ++i2;
        }
        return scaledPath;
    }

    @Override
    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
    }

    @Override
    public void drawArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.drawArc(z, offset, sweep);
    }

    @Override
    public void drawFocus(int x, int y, int w, int h) {
        this.graphics.drawFocus(this.zoomRect(x, y, w, h));
    }

    @Override
    public void drawImage(Image srcImage, int x, int y) {
        org.eclipse.swt.graphics.Rectangle size = srcImage.getBounds();
        this.graphics.drawImage(srcImage, 0, 0, size.width, size.height, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), (int)Math.floor((double)size.width * this.zoom + this.fractionalX), (int)Math.floor((double)size.height * this.zoom + this.fractionalY));
    }

    @Override
    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        Rectangle t = this.zoomRect(tx, ty, tw, th);
        if (!t.isEmpty()) {
            this.graphics.drawImage(srcImage, sx, sy, sw, sh, t.x, t.y, t.width, t.height);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine((int)Math.floor((double)x1 * this.zoom + this.fractionalX), (int)Math.floor((double)y1 * this.zoom + this.fractionalY), (int)Math.floor((double)x2 * this.zoom + this.fractionalX), (int)Math.floor((double)y2 * this.zoom + this.fractionalY));
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.graphics.drawOval(this.zoomRect(x, y, w, h));
    }

    @Override
    public void drawPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.drawPath(scaledPath);
        }
        finally {
            scaledPath.dispose();
        }
    }

    @Override
    public void drawPoint(int x, int y) {
        this.graphics.drawPoint((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY));
    }

    @Override
    public void drawPolygon(int[] points) {
        this.graphics.drawPolygon(this.zoomPointList(points));
    }

    @Override
    public void drawPolygon(PointList points) {
        this.graphics.drawPolygon(this.zoomPointList(points.toIntArray()));
    }

    @Override
    public void drawPolyline(int[] points) {
        this.graphics.drawPolyline(this.zoomPointList(points));
    }

    @Override
    public void drawPolyline(PointList points) {
        this.graphics.drawPolyline(this.zoomPointList(points.toIntArray()));
    }

    @Override
    public void drawRectangle(int x, int y, int w, int h) {
        this.graphics.drawRectangle(this.zoomRect(x, y, w, h));
    }

    @Override
    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRectangle(this.zoomRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    @Override
    public void drawString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawString(s, this.zoomTextPoint(x, y));
        }
    }

    @Override
    public void drawText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y));
        }
    }

    @Override
    public void drawText(String s, int x, int y, int style) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y), style);
        }
    }

    @Override
    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        TextLayout scaled = this.zoomTextLayout(layout);
        if (scaled == null) {
            return;
        }
        try {
            this.graphics.drawTextLayout(scaled, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), selectionStart, selectionEnd, selectionBackground, selectionForeground);
        }
        finally {
            scaled.dispose();
        }
    }

    @Override
    public void fillArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomFillRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.fillArc(z, offset, sweep);
    }

    @Override
    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(this.zoomFillRect(x, y, w, h), vertical);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.graphics.fillOval(this.zoomFillRect(x, y, w, h));
    }

    @Override
    public void fillPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.fillPath(scaledPath);
        }
        finally {
            scaledPath.dispose();
        }
    }

    @Override
    public void fillPolygon(int[] points) {
        this.graphics.fillPolygon(this.zoomPointList(points));
    }

    @Override
    public void fillPolygon(PointList points) {
        this.graphics.fillPolygon(this.zoomPointList(points.toIntArray()));
    }

    @Override
    public void fillRectangle(int x, int y, int w, int h) {
        this.graphics.fillRectangle(this.zoomFillRect(x, y, w, h));
    }

    @Override
    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRectangle(this.zoomFillRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    @Override
    public void fillString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillString(s, this.zoomTextPoint(x, y));
        }
    }

    @Override
    public void fillText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillText(s, this.zoomTextPoint(x, y));
        }
    }

    @Override
    public double getAbsoluteScale() {
        return this.zoom * this.graphics.getAbsoluteScale();
    }

    @Override
    public int getAlpha() {
        return this.graphics.getAlpha();
    }

    @Override
    public int getAntialias() {
        return this.graphics.getAntialias();
    }

    @Override
    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    Font getCachedFont(FontKey key) {
        Font font = (Font)this.fontCache.get(key);
        if (font != null) {
            return font;
        }
        key = new FontKey(key.font, key.height);
        FontData data = key.font.getFontData()[0];
        data.setHeight(key.height);
        Font zoomedFont = this.createFont(data);
        this.fontCache.put(key, zoomedFont);
        return zoomedFont;
    }

    FontData getCachedFontData(Font f) {
        FontData data = (FontData)this.fontDataCache.get(f);
        if (data == null) {
            data = f.getFontData()[0];
            this.fontDataCache.put(f, data);
        }
        return data;
    }

    @Override
    public Rectangle getClip(Rectangle rect) {
        this.graphics.getClip(rect);
        int x = (int)((double)rect.x / this.zoom);
        int y = (int)((double)rect.y / this.zoom);
        rect.width = (int)Math.ceil((double)rect.right() / this.zoom) - x;
        rect.height = (int)Math.ceil((double)rect.bottom() / this.zoom) - y;
        rect.x = x;
        rect.y = y;
        return rect;
    }

    @Override
    public boolean getAdvanced() {
        return this.graphics.getAdvanced();
    }

    @Override
    public int getFillRule() {
        return this.graphics.getFillRule();
    }

    @Override
    public Font getFont() {
        return this.getLocalFont();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics(this.localFont);
    }

    @Override
    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    @Override
    public int getInterpolation() {
        return this.graphics.getInterpolation();
    }

    @Override
    public int getLineCap() {
        return this.graphics.getLineCap();
    }

    @Override
    public int getLineJoin() {
        return this.graphics.getLineJoin();
    }

    @Override
    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    @Override
    public float getLineMiterLimit() {
        return this.graphics.getLineMiterLimit();
    }

    @Override
    public int getLineWidth() {
        return (int)this.getLineWidthFloat();
    }

    @Override
    public float getLineWidthFloat() {
        return this.getLocalLineWidth();
    }

    @Override
    public LineAttributes getLineAttributes() {
        LineAttributes a = this.graphics.getLineAttributes();
        a.width = this.getLocalLineWidth();
        return a;
    }

    private Font getLocalFont() {
        return this.localFont;
    }

    private float getLocalLineWidth() {
        return this.localLineWidth;
    }

    @Override
    public int getTextAntialias() {
        return this.graphics.getTextAntialias();
    }

    @Override
    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    @Override
    public void popState() {
        this.graphics.popState();
        --this.stackPointer;
        this.restoreLocalState((State)this.stack.get(this.stackPointer));
    }

    @Override
    public void pushState() {
        if (this.stack.size() > this.stackPointer) {
            State s = (State)this.stack.get(this.stackPointer);
            s.setValues(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.localLineWidth);
        } else {
            this.stack.add(new State(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.localLineWidth));
        }
        ++this.stackPointer;
        this.graphics.pushState();
    }

    private void restoreLocalState(State state) {
        this.fractionalX = state.appliedX;
        this.fractionalY = state.appliedY;
        this.setScale(state.zoom);
        this.setLocalFont(state.font);
        this.setLocalLineWidth(state.lineWidth);
    }

    @Override
    public void restoreState() {
        this.graphics.restoreState();
        this.restoreLocalState((State)this.stack.get(this.stackPointer - 1));
    }

    @Override
    public void rotate(float degrees) {
        this.graphics.rotate(degrees);
    }

    @Override
    public void scale(double amount) {
        this.setScale(this.zoom * amount);
    }

    @Override
    public void setAdvanced(boolean advanced) {
        this.graphics.setAdvanced(advanced);
    }

    @Override
    public void setAlpha(int alpha) {
        this.graphics.setAlpha(alpha);
    }

    @Override
    public void setAntialias(int value) {
        this.graphics.setAntialias(value);
    }

    @Override
    public void setBackgroundColor(Color rgb) {
        this.graphics.setBackgroundColor(rgb);
    }

    @Override
    public void setClip(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.setClip(scaledPath);
        }
        finally {
            scaledPath.dispose();
        }
    }

    @Override
    public void setBackgroundPattern(Pattern pattern) {
        this.graphics.setBackgroundPattern(pattern);
    }

    @Override
    public void setClip(Rectangle r) {
        this.graphics.setClip(this.zoomClipRect(r));
    }

    @Override
    public void clipPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.clipPath(scaledPath);
        }
        finally {
            scaledPath.dispose();
        }
    }

    @Override
    public void setFillRule(int rule) {
        this.graphics.setFillRule(rule);
    }

    @Override
    public void setFont(Font f) {
        this.setLocalFont(f);
    }

    @Override
    public void setForegroundColor(Color rgb) {
        this.graphics.setForegroundColor(rgb);
    }

    @Override
    public void setForegroundPattern(Pattern pattern) {
        this.graphics.setForegroundPattern(pattern);
    }

    @Override
    public void setInterpolation(int interpolation) {
        this.graphics.setInterpolation(interpolation);
    }

    @Override
    public void setLineCap(int cap) {
        this.graphics.setLineCap(cap);
    }

    @Override
    public void setLineDash(int[] dash) {
        this.graphics.setLineDash(dash);
    }

    @Override
    public void setLineDash(float[] dash) {
        this.graphics.setLineDash(dash);
    }

    @Override
    public void setLineDashOffset(float value) {
        this.graphics.setLineDashOffset(value);
    }

    @Override
    public void setLineJoin(int join) {
        this.graphics.setLineJoin(join);
    }

    @Override
    public void setLineStyle(int style) {
        this.graphics.setLineStyle(style);
    }

    @Override
    public void setLineMiterLimit(float value) {
        this.graphics.setLineMiterLimit(value);
    }

    @Override
    public void setLineWidth(int width) {
        this.setLineWidthFloat(width);
    }

    @Override
    public void setLineWidthFloat(float width) {
        this.setLocalLineWidth(width);
    }

    @Override
    public void setLineAttributes(LineAttributes attributes) {
        this.graphics.setLineAttributes(attributes);
        this.setLocalLineWidth(attributes.width);
    }

    private void setLocalFont(Font f) {
        this.localFont = f;
        this.graphics.setFont(this.zoomFont(f));
    }

    private void setLocalLineWidth(float width) {
        this.localLineWidth = width;
        this.graphics.setLineWidthFloat(this.zoomLineWidth(width));
    }

    void setScale(double value) {
        if (this.zoom != value) {
            this.zoom = value;
            this.graphics.setFont(this.zoomFont(this.getLocalFont()));
            this.graphics.setLineWidthFloat(this.zoomLineWidth(this.localLineWidth));
        }
    }

    @Override
    public void setTextAntialias(int value) {
        this.graphics.setTextAntialias(value);
    }

    @Override
    public void setXORMode(boolean b) {
        this.graphics.setXORMode(b);
    }

    @Override
    public void translate(int dx, int dy) {
        double dxFloat = (double)dx * this.zoom + this.fractionalX;
        double dyFloat = (double)dy * this.zoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    @Override
    public void translate(float dx, float dy) {
        double dxFloat = (double)dx * this.zoom + this.fractionalX;
        double dyFloat = (double)dy * this.zoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    private Rectangle zoomClipRect(Rectangle r) {
        this.tempRECT.x = (int)Math.floor((double)r.x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)r.y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.ceil((double)(r.x + r.width) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.ceil((double)(r.y + r.height) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private Rectangle zoomFillRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w - 1) * this.zoom + this.fractionalX) - this.tempRECT.x + 1;
        this.tempRECT.height = (int)Math.floor((double)(y + h - 1) * this.zoom + this.fractionalY) - this.tempRECT.y + 1;
        return this.tempRECT;
    }

    Font zoomFont(Font f) {
        FontData data;
        int zoomedFontHeight;
        if (f == null) {
            Font localFont = this.getLocalFont();
            f = localFont != null ? localFont : Display.getCurrent().getSystemFont();
        }
        this.allowText = (zoomedFontHeight = this.zoomFontHeight((data = this.getCachedFontData(f)).getHeight())) > 0;
        this.fontKey.setValues(f, zoomedFontHeight);
        return this.getCachedFont(this.fontKey);
    }

    int zoomFontHeight(int height) {
        return (int)(this.zoom * (double)height);
    }

    float zoomLineWidth(float w) {
        return (float)((double)w * this.zoom);
    }

    private int[] zoomPointList(int[] points) {
        int[] scaled = null;
        int i = 0;
        while (i < intArrayCache.length) {
            if (intArrayCache[i].length == points.length) {
                scaled = intArrayCache[i];
                if (i != 0) {
                    int[] temp = intArrayCache[i - 1];
                    ScaledGraphics.intArrayCache[i - 1] = scaled;
                    ScaledGraphics.intArrayCache[i] = temp;
                }
            }
            ++i;
        }
        if (scaled == null) {
            ScaledGraphics.intArrayCache[ScaledGraphics.intArrayCache.length - 1] = new int[points.length];
            scaled = intArrayCache[intArrayCache.length - 1];
        }
        i = 0;
        while (i + 1 < points.length) {
            scaled[i] = (int)Math.floor((double)points[i] * this.zoom + this.fractionalX);
            scaled[i + 1] = (int)Math.floor((double)points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        return scaled;
    }

    private Rectangle zoomRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.floor((double)(y + h) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private TextLayout zoomTextLayout(TextLayout layout) {
        TextLayout zoomed = new TextLayout((Device)Display.getCurrent());
        zoomed.setText(layout.getText());
        int zoomWidth = -1;
        if (layout.getWidth() != -1) {
            zoomWidth = (int)((double)layout.getWidth() * this.zoom);
        }
        if (zoomWidth < -1 || zoomWidth == 0) {
            return null;
        }
        zoomed.setFont(this.zoomFont(layout.getFont()));
        zoomed.setAlignment(layout.getAlignment());
        zoomed.setAscent(layout.getAscent());
        zoomed.setDescent(layout.getDescent());
        zoomed.setOrientation(layout.getOrientation());
        zoomed.setSegments(layout.getSegments());
        zoomed.setSpacing(layout.getSpacing());
        zoomed.setTabs(layout.getTabs());
        zoomed.setWidth(zoomWidth);
        int length = layout.getText().length();
        if (length > 0) {
            int start = 0;
            int offset = 1;
            TextStyle style = null;
            TextStyle lastStyle = layout.getStyle(0);
            while (offset <= length) {
                if (offset == length || (style = layout.getStyle(offset)) != lastStyle) {
                    int end = offset - 1;
                    if (lastStyle != null) {
                        TextStyle zoomedStyle = new TextStyle(this.zoomFont(lastStyle.font), lastStyle.foreground, lastStyle.background);
                        zoomedStyle.rise = lastStyle.rise;
                        zoomedStyle.strikeout = lastStyle.strikeout;
                        zoomedStyle.strikeoutColor = lastStyle.strikeoutColor;
                        zoomedStyle.underline = lastStyle.underline;
                        zoomedStyle.underlineColor = lastStyle.underlineColor;
                        zoomedStyle.underlineStyle = lastStyle.underlineStyle;
                        zoomed.setStyle(zoomedStyle, start, end);
                    }
                    lastStyle = style;
                    start = offset;
                }
                ++offset;
            }
        }
        return zoomed;
    }

    private Point zoomTextPoint(int x, int y) {
        return new Point((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)(y + this.localCache.height - 1) * this.zoom - (double)this.targetCache.height + 1.0 + this.fractionalY));
    }

    private static class FontHeightCache {
        Font font;
        int height;

        private FontHeightCache() {
        }
    }

    static class FontKey {
        Font font;
        int height;

        protected FontKey() {
        }

        protected FontKey(Font font, int height) {
            this.font = font;
            this.height = height;
        }

        public boolean equals(Object obj) {
            return ((FontKey)obj).font.equals((Object)this.font) && ((FontKey)obj).height == this.height;
        }

        public int hashCode() {
            return this.font.hashCode() ^ this.height;
        }

        protected void setValues(Font font, int height) {
            this.font = font;
            this.height = height;
        }
    }

    protected static class State {
        private double appliedX;
        private double appliedY;
        private Font font;
        private float lineWidth;
        private double zoom;

        protected State() {
        }

        protected State(double zoom, double x, double y, Font font, int lineWidth) {
            this(zoom, x, y, font, (float)lineWidth);
        }

        protected State(double zoom, double x, double y, Font font, float lineWidth) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
        }

        protected void setValues(double zoom, double x, double y, Font font, int lineWidth) {
            this.setValues(zoom, x, y, font, (float)lineWidth);
        }

        protected void setValues(double zoom, double x, double y, Font font, float lineWidth) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
        }
    }
}

