/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SchemeBorder
extends AbstractBorder {
    protected Scheme scheme = null;

    protected static final Color[] DARKEST_DARKER() {
        return new Color[]{ColorConstants.buttonDarkest(), ColorConstants.buttonDarker()};
    }

    protected static final Color[] LIGHTER_DARKER() {
        return new Color[]{ColorConstants.buttonLightest(), ColorConstants.buttonDarker()};
    }

    protected static final Color[] DARKER_LIGHTER() {
        return new Color[]{ColorConstants.buttonDarker(), ColorConstants.buttonLightest()};
    }

    protected SchemeBorder() {
    }

    public SchemeBorder(Scheme scheme) {
        this.setScheme(scheme);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return this.getScheme().getInsets();
    }

    protected Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    protected void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        Color[] tl = this.scheme.getHighlight();
        Color[] br = this.scheme.getShadow();
        this.paint(g, figure, insets, tl, br);
    }

    protected void paint(Graphics graphics, IFigure fig, Insets insets, Color[] tl, Color[] br) {
        Color color;
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        graphics.setXORMode(false);
        Rectangle rect = SchemeBorder.getPaintRectangle(fig, insets);
        int top = rect.y;
        int left = rect.x;
        int bottom = rect.bottom() - 1;
        int right = rect.right() - 1;
        int i = 0;
        while (i < br.length) {
            color = br[i];
            graphics.setForegroundColor(color);
            graphics.drawLine(right - i, bottom - i, right - i, top + i);
            graphics.drawLine(right - i, bottom - i, left + i, bottom - i);
            ++i;
        }
        --right;
        --bottom;
        i = 0;
        while (i < tl.length) {
            color = tl[i];
            graphics.setForegroundColor(color);
            graphics.drawLine(left + i, top + i, right - i, top + i);
            graphics.drawLine(left + i, top + i, left + i, bottom - i);
            ++i;
        }
    }

    public static class SCHEMES {
        public static Scheme BUTTON_CONTRAST() {
            return new Scheme(new Color[]{ColorConstants.button(), ColorConstants.buttonLightest()}, SchemeBorder.DARKEST_DARKER());
        }

        public static Scheme BUTTON_RAISED() {
            return new Scheme(new Color[]{ColorConstants.buttonLightest()}, SchemeBorder.DARKEST_DARKER());
        }

        public static Scheme BUTTON_PRESSED() {
            return new Scheme(SchemeBorder.DARKEST_DARKER(), new Color[]{ColorConstants.buttonLightest()});
        }

        public static Scheme RAISED() {
            return new Scheme(new Color[]{ColorConstants.buttonLightest()}, new Color[]{ColorConstants.buttonDarkest()});
        }

        public static Scheme LOWERED() {
            return new Scheme(new Color[]{ColorConstants.buttonDarkest()}, new Color[]{ColorConstants.buttonLightest()});
        }

        public static Scheme RIDGED() {
            return new Scheme(SchemeBorder.LIGHTER_DARKER(), SchemeBorder.DARKER_LIGHTER());
        }

        public static Scheme ETCHED() {
            return new Scheme(SchemeBorder.DARKER_LIGHTER(), SchemeBorder.LIGHTER_DARKER());
        }
    }

    public static class Scheme {
        private Insets insets;
        private boolean isOpaque = false;
        protected Color[] highlight;
        protected Color[] shadow;

        protected Scheme() {
        }

        public Scheme(Color[] highlight, Color[] shadow) {
            this.highlight = highlight;
            this.shadow = shadow;
            this.init();
        }

        public Scheme(Color[] colors) {
            this.shadow = colors;
            this.highlight = colors;
            this.init();
        }

        protected Insets calculateInsets() {
            int tl = this.getHighlight().length;
            int br = this.getShadow().length;
            return new Insets(tl, tl, br, br);
        }

        protected boolean calculateOpaque() {
            Color[] colors = this.getHighlight();
            int i = 0;
            while (i < colors.length) {
                if (colors[i] == null) {
                    return false;
                }
                ++i;
            }
            colors = this.getShadow();
            i = 0;
            while (i < colors.length) {
                if (colors[i] == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected Color[] getHighlight() {
            return this.highlight;
        }

        protected Insets getInsets() {
            return this.insets;
        }

        protected Color[] getShadow() {
            return this.shadow;
        }

        protected void init() {
            this.insets = this.calculateInsets();
            this.isOpaque = this.calculateOpaque();
        }

        protected boolean isOpaque() {
            return this.isOpaque;
        }
    }
}

