/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.ZestStyles;
import org.eclipse.gef4.zest.core.widgets.decoration.IConnectionDecorator;
import org.eclipse.gef4.zest.core.widgets.internal.LoopAnchor;
import org.eclipse.gef4.zest.core.widgets.internal.PolylineArcConnection;
import org.eclipse.gef4.zest.core.widgets.internal.RoundedChopboxAnchor;
import org.eclipse.gef4.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.gef4.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.gef4.zest.layouts.interfaces.NodeLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class GraphConnection
extends GraphItem {
    private Font font;
    private GraphNode sourceNode;
    private GraphNode destinationNode;
    private double weight;
    private Color color;
    private Color highlightColor;
    private Color foreground;
    private int lineWidth;
    private int lineStyle;
    private final Graph graph;
    private int connectionStyle;
    private int curveDepth;
    private boolean isDisposed = false;
    private Label connectionLabel = null;
    private PolylineArcConnection connectionFigure = null;
    private PolylineArcConnection cachedConnectionFigure = null;
    private Connection sourceContainerConnectionFigure = null;
    private Connection targetContainerConnectionFigure = null;
    private boolean visible;
    private IFigure tooltip;
    private boolean highlighted;
    private boolean hasCustomTooltip;
    private ConnectionRouter router = null;
    private IConnectionDecorator connectionDecorator = null;
    private InternalConnectionLayout layout;

    public GraphConnection(Graph graphModel, int style, GraphNode source, GraphNode destination) {
        super((Widget)graphModel, style);
        this.connectionStyle |= graphModel.getConnectionStyle();
        this.connectionStyle |= style;
        this.sourceNode = source;
        this.destinationNode = destination;
        this.visible = true;
        this.color = ColorConstants.lightGray;
        this.foreground = ColorConstants.lightGray;
        this.highlightColor = graphModel.DARK_BLUE;
        this.lineWidth = 1;
        this.lineStyle = 1;
        this.setWeight(1.0);
        this.graph = graphModel;
        this.curveDepth = 0;
        this.font = Display.getDefault().getSystemFont();
        this.registerConnection(source, destination);
    }

    private void registerConnection(GraphNode source, GraphNode destination) {
        if (source.getSourceConnections().contains((Object)this)) {
            source.removeSourceConnection(this);
        }
        if (destination.getTargetConnections().contains((Object)this)) {
            destination.removeTargetConnection(this);
        }
        source.addSourceConnection(this);
        destination.addTargetConnection(this);
        if (source.getParent().getItemType() == 3 && destination.getParent().getItemType() == 3 && source.getParent() == destination.getParent()) {
            this.graph.addConnection(this, false);
        } else {
            this.graph.addConnection(this, true);
        }
        if (source.getParent().getItemType() == 3) {
            this.sourceContainerConnectionFigure = this.doCreateFigure();
            ((GraphContainer)source.getParent()).addConnectionFigure((IFigure)this.sourceContainerConnectionFigure);
            this.setVisible(false);
        }
        if (destination.getParent().getItemType() == 3) {
            this.targetContainerConnectionFigure = this.doCreateFigure();
            ((GraphContainer)destination.getParent()).addConnectionFigure((IFigure)this.targetContainerConnectionFigure);
            this.setVisible(false);
        }
        this.graph.registerItem(this);
    }

    void removeFigure() {
        if (this.connectionFigure.getParent() != null) {
            this.connectionFigure.getParent().remove((IFigure)this.connectionFigure);
        }
        this.connectionFigure = null;
        if (this.sourceContainerConnectionFigure != null) {
            this.sourceContainerConnectionFigure.getParent().remove((IFigure)this.sourceContainerConnectionFigure);
            this.sourceContainerConnectionFigure = null;
        }
        if (this.targetContainerConnectionFigure != null) {
            this.targetContainerConnectionFigure.getParent().remove((IFigure)this.targetContainerConnectionFigure);
            this.targetContainerConnectionFigure = null;
        }
    }

    public void dispose() {
        super.dispose();
        this.isDisposed = true;
        this.getSource().removeSourceConnection(this);
        this.getDestination().removeTargetConnection(this);
        this.graph.removeConnection(this);
        if (this.sourceContainerConnectionFigure != null) {
            this.sourceContainerConnectionFigure.getParent().remove((IFigure)this.sourceContainerConnectionFigure);
        }
        if (this.targetContainerConnectionFigure != null) {
            this.targetContainerConnectionFigure.getParent().remove((IFigure)this.targetContainerConnectionFigure);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public Connection getConnectionFigure() {
        if (this.connectionFigure == null) {
            this.connectionFigure = this.doCreateFigure();
        }
        return this.connectionFigure;
    }

    public Object getExternalConnection() {
        return this.getData();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("GraphModelConnection: ");
        buffer.append(this.sourceNode != null ? this.sourceNode.getText() : "null");
        buffer.append(this.isDirected() ? " --> " : " --- ");
        buffer.append(this.destinationNode != null ? this.destinationNode.getText() : "null");
        buffer.append("  (weight=").append(this.getWeightInLayout()).append(")");
        return buffer.toString();
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setConnectionStyle(int style) {
        this.connectionStyle = style;
        this.updateFigure(this.connectionFigure);
    }

    public double getWeightInLayout() {
        return this.weight;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setWeight(double weight) {
        this.weight = weight < 0.0 ? -1.0 : (weight > 1.0 ? 1.0 : weight);
    }

    public Color getLineColor() {
        return this.color;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setLineColor(Color color) {
        this.foreground = color;
        this.changeLineColor(this.foreground);
    }

    public void changeLineColor(Color color) {
        this.color = color;
        this.updateFigure(this.connectionFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigure(this.connectionFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.updateFigure(this.connectionFigure);
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.updateFigure(this.connectionFigure);
    }

    public GraphNode getSource() {
        return this.sourceNode;
    }

    public GraphNode getDestination() {
        return this.destinationNode;
    }

    public void highlight() {
        if (this.highlighted) {
            return;
        }
        IFigure parentFigure = this.connectionFigure.getParent();
        if (parentFigure instanceof ZestRootLayer) {
            ((ZestRootLayer)parentFigure).highlightConnection((IFigure)this.connectionFigure);
        }
        this.highlighted = true;
        this.updateFigure(this.connectionFigure);
    }

    public void unhighlight() {
        if (!this.highlighted) {
            return;
        }
        IFigure parentFigure = this.connectionFigure.getParent();
        if (parentFigure instanceof ZestRootLayer) {
            ((ZestRootLayer)parentFigure).unHighlightConnection((IFigure)this.connectionFigure);
        }
        this.highlighted = false;
        this.updateFigure(this.connectionFigure);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public Graph getGraphModel() {
        return this.graph;
    }

    public void setCurveDepth(int depth) {
        if (this.curveDepth == 0 && depth != 0 || this.curveDepth != 0 && depth == 0) {
            this.cachedConnectionFigure = this.connectionFigure;
            this.graph.removeConnection(this);
            this.curveDepth = depth;
            this.connectionFigure = this.doCreateFigure();
            this.registerConnection(this.sourceNode, this.destinationNode);
            this.updateFigure(this.connectionFigure);
        } else {
            this.curveDepth = depth;
            this.updateFigure(this.connectionFigure);
        }
    }

    public int getItemType() {
        return 2;
    }

    public void setVisible(boolean visible) {
        if (this.getSource().isVisible() && this.getDestination().isVisible() && visible) {
            this.getFigure().setVisible(visible);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(visible);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(visible);
            }
            this.visible = visible;
        } else {
            this.getFigure().setVisible(false);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(false);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(false);
            }
            this.visible = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setText(String string) {
        super.setText(string);
        if (this.connectionFigure != null) {
            this.updateFigure(this.connectionFigure);
        }
    }

    public boolean isDirected() {
        return ZestStyles.checkStyle(this.connectionStyle, 2);
    }

    public void setDirected(boolean directed) {
        if (directed) {
            this.setConnectionStyle(this.connectionStyle | 2);
        } else {
            this.setConnectionStyle(this.connectionStyle & 0xFFFFFFFD);
        }
    }

    PolylineConnection getSourceContainerConnectionFigure() {
        return (PolylineConnection)this.sourceContainerConnectionFigure;
    }

    PolylineConnection getTargetContainerConnectionFigure() {
        return (PolylineConnection)this.targetContainerConnectionFigure;
    }

    private void updateFigure(PolylineArcConnection connection) {
        if (this.sourceContainerConnectionFigure != null) {
            this.doUpdateFigure(this.sourceContainerConnectionFigure);
        }
        if (this.targetContainerConnectionFigure != null) {
            this.doUpdateFigure(this.targetContainerConnectionFigure);
        }
        this.doUpdateFigure((Connection)connection);
    }

    private void doUpdateFigure(Connection connection) {
        IFigure toolTip;
        if (connection == null || this.isDisposed()) {
            return;
        }
        Shape connectionShape = (Shape)connection;
        connectionShape.setLineStyle(this.getLineStyle());
        if (this.getText() != null || this.getImage() != null) {
            if (this.getImage() != null) {
                this.connectionLabel.setIcon(this.getImage());
            }
            if (this.getText() != null) {
                this.connectionLabel.setText(this.getText());
            }
            this.connectionLabel.setFont(this.getFont());
        }
        if (this.highlighted) {
            connectionShape.setForegroundColor(this.getHighlightColor());
            connectionShape.setLineWidth(this.getLineWidth() * 2);
        } else {
            connectionShape.setForegroundColor(this.getLineColor());
            connectionShape.setLineWidth(this.getLineWidth());
        }
        if (connection instanceof PolylineArcConnection) {
            PolylineArcConnection arcConnection = (PolylineArcConnection)connection;
            arcConnection.setDepth(this.curveDepth);
        }
        if (this.connectionFigure != null) {
            this.applyConnectionRouter((Connection)this.connectionFigure);
        }
        if (this.getTooltip() == null && this.getText() != null && this.getText().length() > 0 && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        connection.setToolTip(toolTip);
        connection.setVisible(this.visible);
    }

    private PolylineArcConnection doCreateFigure() {
        PolylineArcConnection connectionFigure = this.cachedOrNewConnectionFigure();
        ChopboxAnchor sourceAnchor = null;
        ChopboxAnchor targetAnchor = null;
        this.connectionLabel = new Label();
        MidpointLocator labelLocator = null;
        if (this.getSource() == this.getDestination()) {
            sourceAnchor = new LoopAnchor(this.getSource().getNodeFigure());
            targetAnchor = new LoopAnchor(this.getDestination().getNodeFigure());
            labelLocator = new MidpointLocator((Connection)connectionFigure, 0){

                protected Point getReferencePoint() {
                    Point p = Point.SINGLETON;
                    p.x = this.getConnection().getPoints().getPoint((int)this.getIndex()).x;
                    p.y = (int)((double)this.getConnection().getPoints().getPoint((int)this.getIndex()).y - (double)GraphConnection.this.curveDepth * 1.5);
                    this.getConnection().translateToAbsolute((Translatable)p);
                    return p;
                }
            };
        } else {
            if (this.curveDepth != 0) {
                connectionFigure.setDepth(this.curveDepth);
            }
            this.applyConnectionRouter((Connection)connectionFigure);
            sourceAnchor = new RoundedChopboxAnchor(this.getSource().getNodeFigure(), 8);
            targetAnchor = new RoundedChopboxAnchor(this.getDestination().getNodeFigure(), 8);
            labelLocator = new MidpointLocator((Connection)connectionFigure, 0);
        }
        connectionFigure.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        connectionFigure.setTargetAnchor((ConnectionAnchor)targetAnchor);
        connectionFigure.add((IFigure)this.connectionLabel, labelLocator);
        this.applyDecoration(connectionFigure);
        this.doUpdateFigure((Connection)connectionFigure);
        return connectionFigure;
    }

    private PolylineArcConnection cachedOrNewConnectionFigure() {
        return this.cachedConnectionFigure == null ? new PolylineArcConnection() : this.cachedConnectionFigure;
    }

    IFigure getFigure() {
        return this.getConnectionFigure();
    }

    InternalConnectionLayout getLayout() {
        if (this.layout == null) {
            this.layout = new InternalConnectionLayout();
        }
        return this.layout;
    }

    void applyLayoutChanges() {
        if (this.layout != null) {
            this.layout.applyLayout();
        }
    }

    void applyConnectionRouter(Connection conn) {
        if (this.router != null) {
            conn.setConnectionRouter(this.router);
        } else if (this.graph.getDefaultConnectionRouter() != null) {
            conn.setConnectionRouter(this.graph.getDefaultConnectionRouter());
        }
    }

    void applyDecoration(PolylineArcConnection conn) {
        IConnectionDecorator decorator = this.connectionDecorator;
        if (decorator == null) {
            decorator = (this.connectionStyle & 2) > 0 ? this.getGraphModel().getDefaultDirectedConnectionDecorator() : this.getGraphModel().getDefaultConnectionDecorator();
        }
        decorator.decorateConnection(this, conn);
    }

    public void setRouter(ConnectionRouter router) {
        this.router = router;
    }

    public void setConnectionDecoration(IConnectionDecorator connectionDecorator) {
        this.connectionDecorator = connectionDecorator;
        if (this.connectionFigure != null) {
            this.applyDecoration(this.connectionFigure);
            this.updateFigure(this.connectionFigure);
        }
    }

    class InternalConnectionLayout
    implements ConnectionLayout {
        private boolean visible;

        InternalConnectionLayout() {
            this.visible = GraphConnection.this.isVisible();
        }

        public NodeLayout getSource() {
            return GraphConnection.this.sourceNode.getLayout();
        }

        public NodeLayout getTarget() {
            return GraphConnection.this.destinationNode.getLayout();
        }

        public double getWeight() {
            return GraphConnection.this.getWeightInLayout();
        }

        public boolean isDirected() {
            return !ZestStyles.checkStyle(GraphConnection.this.getConnectionStyle(), 2);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            GraphConnection.this.graph.getLayoutContext().checkChangesAllowed();
            this.visible = visible;
        }

        void applyLayout() {
        }
    }
}

