/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.gef4.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.gef4.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;
import org.eclipse.gef4.zest.layouts.interfaces.NodeLayout;

public class TreeLayoutObserver {
    private GraphStructureListener structureListener = new GraphStructureListener(){

        public boolean nodeRemoved(LayoutContext context, NodeLayout node) {
            TreeNode treeNode = (TreeNode)TreeLayoutObserver.this.layoutToTree.get(node);
            treeNode.parent.children.remove(treeNode);
            TreeLayoutObserver.this.superRoot.precomputeTree();
            for (TreeListener listener : TreeLayoutObserver.this.treeListeners) {
                listener.nodeRemoved(treeNode);
            }
            return false;
        }

        public boolean nodeAdded(LayoutContext context, NodeLayout node) {
            TreeNode treeNode = TreeLayoutObserver.this.getTreeNode(node);
            TreeLayoutObserver.this.superRoot.addChild(treeNode);
            TreeLayoutObserver.this.superRoot.precomputeTree();
            for (TreeListener listener : TreeLayoutObserver.this.treeListeners) {
                listener.nodeAdded(treeNode);
            }
            return false;
        }

        public boolean connectionRemoved(LayoutContext context, ConnectionLayout connection) {
            TreeNode node1 = (TreeNode)TreeLayoutObserver.this.layoutToTree.get(connection.getSource());
            TreeNode node2 = (TreeNode)TreeLayoutObserver.this.layoutToTree.get(connection.getTarget());
            if (node1.parent == node2) {
                node1.findNewParent();
                if (node1.parent != node2) {
                    TreeLayoutObserver.this.superRoot.precomputeTree();
                    this.fireParentChanged(node1, node2);
                }
            }
            if (node2.parent == node1) {
                node2.findNewParent();
                if (node2.parent != node1) {
                    TreeLayoutObserver.this.superRoot.precomputeTree();
                    this.fireParentChanged(node2, node1);
                }
            }
            return false;
        }

        public boolean connectionAdded(LayoutContext context, ConnectionLayout connection) {
            TreeNode previousParent;
            TreeNode target;
            TreeNode source = (TreeNode)TreeLayoutObserver.this.layoutToTree.get(connection.getSource());
            if (source == (target = (TreeNode)TreeLayoutObserver.this.layoutToTree.get(connection.getTarget()))) {
                return false;
            }
            if (target.isBetterParent(source)) {
                previousParent = target.parent;
                previousParent.children.remove(target);
                source.addChild(target);
                TreeLayoutObserver.this.superRoot.precomputeTree();
                this.fireParentChanged(target, previousParent);
            }
            if (!connection.isDirected() && source.isBetterParent(target)) {
                previousParent = source.parent;
                previousParent.children.remove(source);
                target.addChild(source);
                TreeLayoutObserver.this.superRoot.precomputeTree();
                this.fireParentChanged(source, previousParent);
            }
            return false;
        }

        private void fireParentChanged(TreeNode node, TreeNode previousParent) {
            for (TreeListener listener : TreeLayoutObserver.this.treeListeners) {
                listener.parentChanged(node, previousParent);
            }
        }
    };
    private final HashMap layoutToTree = new HashMap();
    private final TreeNodeFactory factory;
    private final LayoutContext context;
    private TreeNode superRoot;
    private ArrayList treeListeners = new ArrayList();

    public TreeLayoutObserver(LayoutContext context, TreeNodeFactory nodeFactory) {
        this.factory = nodeFactory == null ? new TreeNodeFactory() : nodeFactory;
        this.context = context;
        context.addGraphStructureListener(this.structureListener);
        this.recomputeTree();
    }

    public void recomputeTree() {
        this.superRoot = this.factory.createTreeNode(null, this);
        this.layoutToTree.put(null, this.superRoot);
        this.createTrees(this.context.getNodes());
    }

    public void stop() {
        this.context.removeGraphStructureListener(this.structureListener);
    }

    public TreeNode getSuperRoot() {
        return this.superRoot;
    }

    public TreeNode getTreeNode(NodeLayout node) {
        TreeNode treeNode = (TreeNode)this.layoutToTree.get(node);
        if (treeNode == null) {
            treeNode = this.factory.createTreeNode(node, this);
            this.layoutToTree.put(node, treeNode);
        }
        return treeNode;
    }

    public void addTreeListener(TreeListener listener) {
        this.treeListeners.add(listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.treeListeners.add(listener);
    }

    private void createTrees(NodeLayout[] nodes) {
        HashSet<NodeLayout> alreadyVisited = new HashSet<NodeLayout>();
        LinkedList<Object[]> nodesToAdd = new LinkedList<Object[]>();
        int i = 0;
        while (i < nodes.length) {
            NodeLayout root = this.findRoot(nodes[i], alreadyVisited);
            if (root != null) {
                alreadyVisited.add(root);
                nodesToAdd.addLast(new Object[]{root, this.superRoot});
            }
            ++i;
        }
        while (!nodesToAdd.isEmpty()) {
            Object[] dequeued = (Object[])nodesToAdd.removeFirst();
            TreeNode currentNode = this.factory.createTreeNode((NodeLayout)dequeued[0], this);
            this.layoutToTree.put(dequeued[0], currentNode);
            TreeNode currentRoot = (TreeNode)dequeued[1];
            currentRoot.addChild(currentNode);
            NodeLayout[] children = currentNode.node.getSuccessingNodes();
            int i2 = 0;
            while (i2 < children.length) {
                if (!alreadyVisited.contains(children[i2])) {
                    alreadyVisited.add(children[i2]);
                    nodesToAdd.addLast(new Object[]{children[i2], currentNode});
                }
                ++i2;
            }
        }
        this.superRoot.precomputeTree();
    }

    private NodeLayout findRoot(NodeLayout nodeLayout, Set alreadyVisited) {
        HashSet<NodeLayout> alreadyVisitedRoot = new HashSet<NodeLayout>();
        while (true) {
            if (alreadyVisited.contains(nodeLayout)) {
                return null;
            }
            if (alreadyVisitedRoot.contains(nodeLayout)) {
                return nodeLayout;
            }
            alreadyVisitedRoot.add(nodeLayout);
            NodeLayout[] predecessingNodes = nodeLayout.getPredecessingNodes();
            if (predecessingNodes.length <= 0) break;
            nodeLayout = predecessingNodes[0];
        }
        return nodeLayout;
    }

    public static class TreeListener {
        public void nodeAdded(TreeNode newNode) {
            this.defaultHandle(newNode);
        }

        public void nodeRemoved(TreeNode removedNode) {
            this.defaultHandle(removedNode);
        }

        public void parentChanged(TreeNode node, TreeNode previousParent) {
            this.defaultHandle(node);
        }

        protected void defaultHandle(TreeNode changedNode) {
        }
    }

    public static class TreeNode {
        protected final NodeLayout node;
        protected final TreeLayoutObserver owner;
        protected int height = 0;
        protected int depth = -1;
        protected int numOfLeaves = 0;
        protected int numOfDescendants = 0;
        protected int order = 0;
        protected final List children = new ArrayList();
        protected TreeNode parent;
        protected boolean firstChild = false;
        protected boolean lastChild = false;

        public NodeLayout getNode() {
            return this.node;
        }

        public TreeLayoutObserver getOwner() {
            return this.owner;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getNumOfLeaves() {
            return this.numOfLeaves;
        }

        public int getNumOfDescendants() {
            return this.numOfDescendants;
        }

        public int getOrder() {
            return this.order;
        }

        public List getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isFirstChild() {
            return this.firstChild;
        }

        public boolean isLastChild() {
            return this.lastChild;
        }

        protected TreeNode(NodeLayout node, TreeLayoutObserver owner) {
            this.node = node;
            this.owner = owner;
        }

        protected void addChild(TreeNode child) {
            if (child == this) {
                return;
            }
            this.children.add(child);
            child.parent = this;
        }

        protected void precomputeTree() {
            if (this.children.isEmpty()) {
                this.height = 0;
                this.numOfLeaves = 1;
                this.numOfDescendants = 0;
            } else {
                this.height = 0;
                this.numOfLeaves = 0;
                this.numOfDescendants = 0;
                ListIterator iterator = this.children.listIterator();
                while (iterator.hasNext()) {
                    TreeNode child = (TreeNode)iterator.next();
                    child.depth = this.depth + 1;
                    child.order = this.order + this.numOfLeaves;
                    child.precomputeTree();
                    child.firstChild = this.numOfLeaves == 0;
                    child.lastChild = !iterator.hasNext();
                    this.height = Math.max(this.height, child.height + 1);
                    this.numOfLeaves += child.numOfLeaves;
                    this.numOfDescendants += child.numOfDescendants + 1;
                }
            }
        }

        protected void findNewParent() {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            NodeLayout[] predecessingNodes = this.node.getPredecessingNodes();
            this.parent = null;
            int i = 0;
            while (i < predecessingNodes.length) {
                TreeNode potentialParent = (TreeNode)this.owner.layoutToTree.get(predecessingNodes[i]);
                if (!this.children.contains(potentialParent) && this.isBetterParent(potentialParent)) {
                    this.parent = potentialParent;
                }
                ++i;
            }
            if (this.parent == null) {
                this.parent = this.owner.superRoot;
            }
            this.parent.addChild(this);
        }

        protected boolean isBetterParent(TreeNode potentialParent) {
            if (potentialParent == null) {
                return false;
            }
            if (this.parent == null && !this.isAncestorOf(potentialParent)) {
                return true;
            }
            if (potentialParent.depth <= this.depth && potentialParent.depth != -1) {
                return true;
            }
            return this.parent != null && this.parent.depth == -1 && potentialParent.depth >= 0 && !this.isAncestorOf(potentialParent);
        }

        public boolean isAncestorOf(TreeNode descendant) {
            while (descendant.depth > this.depth && descendant != descendant.parent) {
                descendant = descendant.parent;
            }
            return descendant == this;
        }
    }

    public static class TreeNodeFactory {
        public TreeNode createTreeNode(NodeLayout nodeLayout, TreeLayoutObserver observer) {
            return new TreeNode(nodeLayout, observer);
        }
    }
}

